require( "HiddenObject/script/style.lua" );

OkGraphics = {
	"HiddenObject/UI/Button/oknormal.png",
	"HiddenObject/UI/Button/okdown.png",
	"HiddenObject/UI/Button/okover.png",
};

ButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  24,
  Color(131, 167, 184, 255)
};	

OkStyle= {
	type = kPush,
	flags = kHAlignCenter,
	font = ButtonFont,
	graphics = OkGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

gCurScreen = 0;
yGap = 30;
xGap = 60;

LeftGraphics = {
	"HiddenObject/UI/Button/leftnormal.png",
	"HiddenObject/UI/Button/leftdown.png",
	"HiddenObject/UI/Button/leftover.png",
};	

LeftStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = LeftGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

RightGraphics = {
	"HiddenObject/UI/Button/rightnormal.png",
	"HiddenObject/UI/Button/rightdown.png",
	"HiddenObject/UI/Button/rightover.png",
};	

RightStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = RightGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};


HelpDialogBodyFont4 = {
  standardFont,
  18,
  Color(173,193,161,255)
};
HelpDialogBodyText4 = {
	parent=DefaultStyle,
	font = HelpDialogBodyFont,
	flags = kVAlignCenter + kHAlignCenter,
	w=kMax,h=38
};

function SetScreen( screen )

	if screen == 1 then
		EnableWindow("helptext1",true)	
	end
	gCurScreen = screen ;
end

HeaderFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  30,
  Color(173,193,161,255)
};

TextStyle=
{
	parent=HelpDialogBodyText4,
	w=320,h=kMax-40
};
function GetWindowX()
	
	x = kCenter;
	if IsMainMenu() then x = 310; end
	return x;
end

function GetWindowY()
	
	y = kCenter - 45;
	if IsMainMenu() then y = 115; end
	return y;
end

MakeDialog
{
	-- Name the modal dialog
	name="help",
	Bitmap
	{
		image="HiddenObject/UI/HelpWindow/background",
		x=GetWindowX(),
		y=GetWindowY(),
		
		Window
		{
			name="helptext1",
			w=kMax,h=kMax,

			SetStyle(HelpDialogBodyText4),
			Text
			{
				x = kHAlignCenter;
				y = 10;
				name = "title",
				label= "mastermind",
				font = StandardHeaderFont, h = 40,
			};
		
			SetStyle(TextStyle),
			Text
			{
				label="mastermindhelp1",
				flags = kHAlignCenter ,
				x=50,
				y=70,
			},

			SetStyle(OkStyle),
			Button
			{
				label="close",
				name="close",
				flags = kVAlignCenter + kHAlignCenter,
				x=xGap,y=327,
				command=function() CloseWindow(); end;
			},
		},
	}
}

SetScreen(1);